<!DOCTYPE html>
<html>

<head>
  <!--Import Google Icon Font-->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp"
    crossorigin="anonymous">
  <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
  <!--Import materialize.css-->
  <link type="text/css" rel="stylesheet" href="css/materialize.min.css" media="screen,projection" />
  <link type="text/css" rel="stylesheet" href="css/main.css" />
  

  <!--Let browser know website is optimized for mobile-->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Contact : 3rd International Conference on Advanced Computational Intelligence (ACINT 2025)</title>
<link rel="icon" type="image/png" href="img/logo.png">

</head>

<body>

  <!-- Responsive NavBar -->
  <div class="navbar-fixed">
    <nav class="cyan lighten-2 z-depth-5">
      <div class="container">
        <div class="nav-wrapper">
          <ul>
            <li id="b-logo">
                   <img id="brand-logo" class="hide-on-med-and-down" src="img/logo.png" height="65" width="80">
            </li>
          </ul>
          <a class="brand-logo" href="index">ACINT</a>
          <a data-activates="side-nav" class="button-collapse show-on-small left">
            <i class="material-icons">menu</i>
          </a>
          <ul class="right hide-on-med-and-down">
            <li>
              <a href="index">Home</a>
            </li>
            <li>
              <a href="papersubmission">Paper Submission</a>
            </li>
            <li >
              <a href="committee">Program Committee</a>
            </li>
			  <li>
              <a href="papers">Accepted Papers</a>
            </li>
			<li >
              <a href="venue">Venue</a>
            </li>
            <li  class="active">
              <a href="contact">Contact</a>
            </li>
           </ul>
        </div>
      </div>
    </nav>
  </div>

  <!-- SIDE NAVBAR -->

  <ul class="side-nav" id="side-nav">
    <li>
      <div class="user-view arc">
       
        <a href="">
          <i id="cl" class="material-icons cyan-text text-lighten-2 right">close</i>
        </a>
        <a href="">
          <img class="circle" src="img/logo.png">
        </a>
        <h4 class="grey-text">ACINT</h4>
      </div>
    </li>
    <li>
      <a href="index">Home
        <i class="material-icons">home</i>
      </a>
    </li>
	<li>
      <a href="papersubmission">Paper Submission
        <i class="fas fa-paper-plane "></i>
      </a>
    </li>
    <li >
      <a href="committee">Program Committee
        <i class="fas fa-users"></i>
      </a>
    </li>
    <li>
      <a href="papers">Accepted Papers
        <i class="fas fa-calendar-alt"></i>
      </a>
    </li>
	<li >
      <a href="venue">Venue
        <i class="fas fa-map"></i>
      </a>
    </li>
    <li  class="active">
      <a href="contact">Contact
        <i class="fas fa-phone"></i>
      </a>
    </li>
   
  </ul>

  <!-- Section: Slider -->
<section class="section-slider slider">
   <div class="fixed-action-btn" id="scrollTop">
      <a class="btn btn-small btn-floating waves-effect waves-light blue lighten-1 pulse" onclick="topFunction()">
        <i class="material-icons">keyboard_arrow_up</i>
      </a>
    </div>
           <ul class="slides">
	 <li>
        <img src="img/sc-img1.jpeg" alt="">
       <div class="hide-on-med-and-up caption center-align pd">
           <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption center-align pc">
          <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
         
        </div>
      </li>
      <li>
        <img src="img/sc-img2.jpeg" alt="">
        <div class="hide-on-med-and-up caption left-align pd">
        <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption left-align pc">
        <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
          </div>
      </li>
        <li>
        <img src="img/sc-img3.jpg" alt="">
        <div class="hide-on-med-and-up caption right-align pd">
        <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption right-align pc">
         <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025)</h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
          </div>
      </li>
    </ul>
  </section>
  <!-- Main Section - Left -->
  <section class="section-main">
    <div class="container">
      <div class="row">
        <div class="col s12 m12">
         
        <div class="card-content">
              <h5 class="cyan-text center text-darken-1">Contact Us</h5>
            </div>
		
		<div class="card z-depth-2">
            <div class="card-content">
              
			  <p style="text-align:center">Here's where you can reach us : <a href="mailto:acint@csitai2025.org">acint@csitai2025.org</a> or <a href="mailto:acintconf@gmail.com">acintconf@gmail.com</a></p>
			  
			  <br><br><br><br><br><br><br><br><br>
			  
            </div>
         </div>
		
		
		
		
		
		
		
		</div>
      
      </div>
    </div>
  </section>




  <div class="fixed-action-btn">
    <a id="menu" class="btn btn-floating cyan lighten-2 waves-effect waves-light pulse" onmouseover="$('.tap-target').tapTarget('open')">
      <i class="material-icons white-text">menu</i>
    </a>
  </div>

   <div class="tap-target-wrapper right-align">
    <div class="tap-target cyan" data-activates="menu">
      <div class="tap-target-content white-text">
        <h5>Reach Us</h5>
        <br>
         <i class="material-icons right">email</i>acint@csitai2025.org
        <br>
        <br>

        <br>
          <i class="material-icons right">email</i>acintconf@gmail.com
		 <br>
        <br>
      </div>
    </div>
    <div class="tap-target-wave ">
      <a class="btn-floating cyan tap-target-origin waves-effect waves-light" onmousewheel="$('.tap-target').tapTarget('close')">
        <i class="material-icons cyan">close</i>
      </a>
    </div>
  </div>





  <!-- Dummy Div-->

  <div id="txtcnt"></div>

  <!-- Section: Footer -->

  <footer class="page-footer cyan lighten-3">
    <div class="container">
      <div class="row">
        <div class="footer-m col m3 s12 offset-m2">
          <ul>
            <li>
              <a class="white-text" href="contact">Contact</a>
            </li>
            <li>
              <a style="color: #e6dbdb;" href="mailto:acint@csitai2025.org"><b>acint@csitai2025.org</b></a>
            </li>
          </ul>
        </div>

        <div class="social col m4 offset-m3 s12">
          <ul>
           <li>
              <a href="https://www.facebook.com/profile.php?id=61583791508242" target="_blank" ><img  widht="40" height="40" src="/img/fb.png"/></a>
            </li>
            <li>
              <a href="https://x.com/CSIT58" target="_blank" ><img  widht="40" height="40" src="/img/x.png"/></a>
            </li>
            <li>
                     <a href="https://www.youtube.com/@computerscienceitconferenc7375" target="_blank" ><img  widht="40" height="40" src="/img/csitn.jpg"/></a><br><br>

              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>

    <div class="footer-copyright grey darken-2">
      <div class="container center-align">
        <large class="white-text"> All Rights Reserved &reg;
          ACINT 2025
        </large>
      </div>
    </div>

   
  </footer>
<!--Import jQuery before materialize.js-->
<script type="text/javascript" src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="js/materialize.min.js"></script>
<script src="js/scrolltop.js"></script>

<script src="js/main.jquery.js"></script>
</body>


</html>