<!DOCTYPE html>
<html>

<head>
  <!--Import Google Icon Font-->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.0.13/css/all.css" integrity="sha384-DNOHZ68U8hZfKXOrtjWvjxusGo9WQnrNx2sqG0tfsghAvtVlRW3tvkXWZh58N9jp"
    crossorigin="anonymous">
  <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
  <!--Import materialize.css-->
  <link type="text/css" rel="stylesheet" href="css/materialize.min.css" media="screen,projection" />
  <link type="text/css" rel="stylesheet" href="css/main.css" />
  

  <!--Let browser know website is optimized for mobile-->
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="title" content="3rd International Conference on Advanced Computational Intelligence (ACINT 2025)">
  <meta name="description" content="3rd International Conference on Advanced Computational Intelligence (ACINT 2025) will provide an excellent international forum for sharing knowledge and results in theory, methodology and applications of Computational Intelligence. Authors are solicited to contribute to this Conference by submitting articles that illustrate research results, projects, surveying works and industrial experiences that describe significant advances in the computational intelligence.

Authors are solicited to contribute to the conference by submitting articles that illustrate research results, projects, surveying works and industrial experiences that describe significant advances in the areas of Computer Science, Engineering and Applications">
  <meta name="robots" content="index, follow">
  <meta name="keywords" content="Artificial intelligence, Cellular automata, Connectionist systems, Multimedia, Human Interface Systems, Genetic algorithms">
  <meta name="audience" content="all">
  <meta name="distribution" content="global">
  <meta name="imagetoolbar" content="no">
  <title>3rd International Conference on Advanced Computational Intelligence (ACINT 2025) </title>
<link rel="icon" type="image/png" href="img/logo.png">

</head>
<style>
.rounded {
  flex: none;
  width: 100px;
  height: 100px;
  border-radius: 80%;
  object-fit: cover;
}</style>
<body>

  <!-- Responsive NavBar -->
  <div class="navbar-fixed">
    <nav class="cyan lighten-2 z-depth-5">
      <div class="container">
        <div class="nav-wrapper">
          <ul>
            <li id="b-logo">
              <img id="brand-logo" class="hide-on-med-and-down" src="img/logo.png" height="65" width="80">
            </li>
          </ul>
          <a class="brand-logo" href="index">ACINT</a>
          <a data-activates="side-nav" class="button-collapse show-on-small left">
            <i class="material-icons">menu</i>
          </a>
          <ul class="right hide-on-med-and-down">
            <li class="active">
              <a href="index">Home</a>
            </li>
             <li>
              <a href="papersubmission">Paper Submission</a>
            </li>
            <li>
              <a href="committee">Program Committee</a>
            </li>
			  <li>
              <a href="papers">Accepted Papers</a>
            </li>
			<li>
              <a href="venue">Venue</a>
            </li>
            <li>
              <a href="contact">Contact</a>
            </li>
           </ul>
        </div>
      </div>
    </nav>
  </div>

  <!-- SIDE NAVBAR -->

  <ul class="side-nav" id="side-nav">
    <li>
      <div class="user-view arc">
       
        <a href="index">
          <i id="cl" class="material-icons cyan-text text-lighten-2 right">close</i>
        </a>
        <a href="index">
          <img class="circle" src="img/logo.png">
        </a>
        <h4 class="grey-text">ACINT</h4>
      </div>
    </li>
    <li class="active">
      <a href="index">Home
        <i class="material-icons">home</i>
      </a>
    </li>
	<li>
      <a href="papersubmission">Paper Submission
        <i class="fas fa-paper-plane "></i>
      </a>
    </li>
    <li>
      <a href="committee">Program Committee
        <i class="fas fa-users"></i>
      </a>
    </li>
    <li>
      <a href="papers">Accepted Papers
        <i class="fas fa-calendar-alt"></i>
      </a>
    </li>
	<li>
      <a href="venue">Venue
        <i class="fas fa-map"></i>
      </a>
    </li>
    <li>
      <a href="contact">Contact
        <i class="fas fa-phone"></i>
      </a>
    </li>
   
  </ul>

 
  <!-- Section: Slider -->
<section class="section-slider slider">
   <div class="fixed-action-btn" id="scrollTop">
      <a class="btn btn-small btn-floating waves-effect waves-light blue lighten-1 pulse" onclick="topFunction()">
        <i class="material-icons">keyboard_arrow_up</i>
      </a>
    </div>
           <ul class="slides">
	 <li>
        <img src="img/sc-img1.jpeg" alt="">
       <div class="hide-on-med-and-up caption center-align pd">
           <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption center-align pc">
          <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
         
        </div>
      </li>
      <li>
        <img src="img/sc-img2.jpeg" alt="">
        <div class="hide-on-med-and-up caption left-align pd">
        <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption left-align pc">
        <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
          </div>
      </li>
        <li>
        <img src="img/sc-img3.jpg" alt="">
        <div class="hide-on-med-and-up caption right-align pd">
        <h5>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h5>
		  <h5 class="abx cyan">December 27 ~ 28, 2025, Dubai, UAE</h5>
        </div>
        <div class="hide-on-small-only caption right-align pc">
         <h3>3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </h3>
          <h5 class="abx ">December 27 ~ 28, 2025, Dubai, UAE</h5>
          <br>
          </div>
      </li>
    </ul>
  </section>
  <p  style="width: 100%;    line-height: 35px;       background: linear-gradient(23deg, #f46b36 0%,#bd9473 30%,#8e3710 100%);  text-align:center;  color:  #fff; font-size: 20px;"  >Hybrid -- Registered authors can present their work online or face to face <sup style="color:yellow">New</sup></p>
  <!-- Main Section - Left -->
  <section class="section-main">
    <div class="container">
      <div class="row">
        <div class="col s12 m8">
         
        
          <!-- Section: Conferences -->

     <div id="section-aircc" class="sec-main">

            <div class="card">
              <span class="left-align">
                <h5 id="about" class="brown-text text-darken-2  lighten-3">SCOPE</h5>
               
              </span>
              <div class="card-content cyan lighten-5">

                <p style="text-align:justify">
                 <span style="color:#c918de">3<sup>rd</sup>  International Conference on Advanced Computational Intelligence (ACINT 2025) </span> will provide an excellent international forum for sharing knowledge and results in theory, methodology and applications of Computational Intelligence. Authors are solicited to contribute to this Conference by submitting articles that illustrate research results, projects, surveying works and industrial experiences that describe significant advances in the computational intelligence.</p>
                <br>
<p style="text-align:justify">Authors are solicited to contribute to the conference by submitting articles that illustrate research results, projects, surveying works and industrial experiences that describe significant advances in the areas of Computer Science, Engineering and Applications.</p>
                

              </div>
            </div>
          </div>



          <!-- IS JOURNALS: HORIZONTAL CARD -->
          <div id="section-is" class="sec-main">
            <div class="card">
              
                <span class="card-title">
                  <p id="is" class="ai cyan lighten-3">Topics of interest</p>
                  <div class="divider"></div>
                </span>
             
              <div class="card-content">
               <ul class="ultopics">
  

<li>Artificial intelligence</li>
<li>Cellular automata</li>
<li>Connectionist systems</li>
<li>Distributed, Multimedia, Human Interface Systems</li>
<li>Evolutionary computation</li>
<li>Fuzzy logic</li>
<li>Genetic algorithms</li>
<li>Hybrid intelligent systems, Adaptation and Learning Systems</li>
<li>Knowledge mining</li>
<li>Neural networks</li>
<li>Pattern recognition</li>
<li>Self-organizing systems</li>
<li>Soft computing</li>
<li>Statistical models</li>
<li>Symbolic machine learning</li>

				
               </ul>
              </div>
              <!-- </div> -->
  </div>
          </div>

        

          <!-- ERA LISTED: HORIZONTAL CARD -->
          <div class="card z-depth-2" id="csec">
            <div class="card-content">
              <h5 class="cyan-text text-darken-1">Paper Submission</h5>
            </div>
          
			<div id="section-aircc" class="sec-main">

            <div class="card">
                    <div class="card-content cyan lighten-5">

      <p style="text-align:justify">
                 Authors are invited to submit papers through the conference <a target="blank" style="color:#2fabbe"  href="https://csitai2025.org/submission/index.php">Submission System</a> by <b><?php include '../dates/day1.php';?></b></b>. Submissions must be original and should not have been published previously or be under consideration for publication while being evaluated for this conference. The proceedings of the conference will be published by <a style="color:#2fabbe" href="https://csitcp.com/" target="blank">Computer Science Conference Proceedings</a> (H index 43) in <a style="color:#2fabbe" href="https://csitcp.com/vol15" target="blank">Computer Science & Information Technology (CS & IT)</a> series (Confirmed).</p>
                <br>
				
				 <p style="text-align:justify">Selected papers from <strong>ACINT 2025</strong>, after further revisions, will be published in the special issue of the following journals</p><br>
	
				
	  			<li><a href="https://airccse.org/journal/acii/index.html" target="_blank">Advanced Computational Intelligence: An International Journal (ACII)</a></li>
				
				<li><a href="https://airccse.com/caij/index.html" target="_blank">Computer Applications: An International Journal (CAIJ)</a></li>

               <li><a href="https://airccse.org/journal/acij/acij.html" target="_blank">Advanced Computing: An International Journal (ACIJ)</a></li>
                 
            				
				<li><a href="https://wireilla.com/ijfcst/index.html" target="_blank">International Journal in Foundations of Computer Science & Technology (IJFCST)</a></li>
				
				<li><a href="https://it-in-industry.com/" target="_blank">Information Technology in Industry (ITII)</a></li>	
				
    
            </ul>
				
			
              </div>
            </div>
          </div>
        </div>
		
		<div id="section-is" class="sec-main">
            <div class="card">
              
                <span class="card-title">
                  <p id="is" class="ai cyan lighten-3">Important Dates</p>
                  <div class="divider"></div>
                </span>
             
              
              <div class="card-content cyan white-text">
                   <p><span style="color: yellow;"><?php include '../dates/batchdates.php';?>
        </span></p>
           <br>
             
<i class="material-icons left">calendar_today</i><span>Submission Deadline : <b><?php include '../dates/day1.php';?></b></b></span>
              <br>
               <br>
<i class="material-icons left">calendar_today</i><span>Authors Notification : <b><?php include '../dates/day2.php';?></b></b></span>
              <br>
              <br>
<i class="material-icons left">calendar_today</i><span>Registration & Camera-Ready Paper Due : <b><?php include '../dates/day3.php';?></b></b></span>
              <br>
            </div>
              
              <!-- </div> -->
            </div>
          </div>
		
		 <!--proceedings-->
		<div id="section-confpro" class="sec-main">
            <div class="card">
              <div class="card-image">
                <img src="img/book.jpg" alt="image/jpg">
                <span class="card-title">
                  <p id="cp" class="ai">CONFERENCE PROCEEDINGS</p>
                  <div class="divider"></div>
                </span>
              </div>
              <div class="card-content">
                <br>
                <p class="left-text">Hard copy of the proceedings will be distributed during the Conference. The softcopy will be available on AIRCC digital library.
                  <span>
                   <a target="blank" href="https://airccj.org/csecfp/library/index.php">
                      <i class="fas fa-external-link-alt"></i>
                    </a>
                  </span>
                </p>
              </div>
            </div>
          </div>
		
	<?php include '../speakers.php';?>	
		
		
		</div>





        <!-- Right Side Bar -->

        <div id="side-bar" class="col s12 m4">

		 <p class="ai brown-text text-darken-2">
           Paper Submission
          </p>
          <div class="card side cyan lighten-2">
  <div class="card-content">
              <a href="https://csitai2025.org/submission/index.php" target="blank" class="ax white-text">
                <i class="material-icons left">submission</i>Submission System</a>
            
            </div>
          </div>
		
		
		 <p class="ai brown-text text-darken-2">
           Template
          </p>
          <div class="card side cyan lighten-2">
           
            <div class="card-content">
                
               
                 <div class="col s12 m6">
                    
                  <a  href="/template.doc" target="blank" class="ax white-text">
                <i class="material-icons left">file_copy</i>Doc</a>
                    
                </div>
             <br>
            </div>
          </div>
		
<!--<div class="card side cyan lighten-2">
     
     	<p style="width: 100%;line-height: 35px;text-align:center;  color:  #fff;"  >Due to the current COVID-19 pandemic, registered authors are now able to present their work through our online platforms <sup style="color:yellow"><img src="img/new.gif"></img></sup></p>
	 </div>-->
		
		  <p class="ai brown-text text-darken-2">
            Other Conferences
          </p>
          <div class="card side cyan lighten-2">
            <div class="divider"></div>
            <div class="card-content">
              <a href="https://csitai2025.org/comsap/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>COMSAP 2025</a>
              <br>
              <br>
              <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/istech/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ISTECH 2025</a>
              <br>
              <br>
              <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/itcau/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ITCAU 2025</a>
              <br>
              <br>
			  <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>CSITAI 2025</a>
              <br>
              <br>
			  <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/aicivil/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>AICiViL 2025</a>
              <br>
              <br>
               <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/energy/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ENERGY 2025</a>
              <br>
              <br>
			  <div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/coraj/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>CORAJ 2025</a>
              <br>
              <br>
<div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/mathcs/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>MATHCS 2025</a>
              <br>
              <br>
<div class="divider"></div>
              <br>
              <a href="https://csitai2025.org/iteory/index" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ITEORY 2025</a>
              <br>
              <br>			  
              
            </div>
			
          </div>
		  
		  
		  <!-- Past Events-->
		 
					<p class="ai brown-text text-darken-2">
            Past Events
          </p>
          <div class="card side cyan lighten-2">
            <div class="divider"></div>
            <div class="card-content">
			<a href="https://acint2024.org/" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ACINT 2024</a>
             <br>
			<br>
			<a href="https://ijcionline.com/" target="_blank" class="ax white-text">
                <i class="material-icons left">event</i>ACINT 2023</a>
             <br>
			<br>
				 
            </div>
          </div>
		  
		  
		 
         

		 <p class="ai brown-text text-darken-2">
            Courtesy
          </p>
			
			<div class="card-content center-align">
              
            <p><a href="http://airccse.org/cscp.html" target="_blank" ><img src="img/sponser1.gif" alt="csit"></a><br />
            <p><a href="http://allconferencecfpalerts.com/cfp/shareurl.php" target="_blank" ><img src="img/sponser2.png" alt="share url"></a><br />
			<p><a href="http://allconferencecfpalerts.com/cfp/OA.html" target="_blank" ><img src="img/sponser3.png" alt="allconferencecfpalerts"></a><br />
			</div>
			
		<p class="ai brown-text text-darken-2">
            Supported By
          </p>
			
			<div class="card-content center-align">
 
		
        <a href="https://airccse.org/journal/acii/index.html" target="_blank" ><img width="70%" height="100px" src="img/jlogos/ijcsit.png" alt="IJCSIT"></a><br><br>
			
			</div>
			<div class="card-content center-align">

<a href="https://www.youtube.com/@computerscienceitconferenc7375" target="_blank" ><img class="rounded" src="/img/csitn.jpg"/></a><br><br>
</div>

 
          </div>
          </div>
      </div>
   
  </section>




  <div class="fixed-action-btn">
    <a id="menu" class="btn btn-floating cyan lighten-2 waves-effect waves-light pulse" onmouseover="$('.tap-target').tapTarget('open')">
      <i class="material-icons white-text">menu</i>
    </a>
  </div>

   <div class="tap-target-wrapper right-align">
    <div class="tap-target cyan" data-activates="menu">
      <div class="tap-target-content white-text">
        <h5>Reach Us</h5>
        <br>
         <i class="material-icons right">email</i>acint@csitai2025.org

        <br>
        <br>

        <br>
          <i class="material-icons right">email</i>acintconf@gmail.com
		 <br>
        <br>
      </div>
    </div>
    <div class="tap-target-wave ">
      <a class="btn-floating cyan tap-target-origin waves-effect waves-light" onmousewheel="$('.tap-target').tapTarget('close')">
        <i class="material-icons cyan">close</i>
      </a>
    </div>
  </div>





  <!-- Dummy Div-->

  <div id="txtcnt"></div>

   <!-- Section: Footer -->

  <footer class="page-footer cyan lighten-3">
    <div class="container">
      <div class="row">
         <div class="footer-m col m2 s12 center">
          <ul>
            <li>
              <a class="white-text" href="contact">Contact</a>
            </li>
            <li>
              <a style="color: #e6dbdb;" href="mailto:acint@csitai2025.org"><b>acint@csitai2025.org</b></a>
            </li>
          </ul>
        </div>
        
        <div class="social col m8 s12 center">
            
            
          
  
  

</div>

  <div class="social col m2 s12 center">
<ul>
<li>
              <a href="https://www.facebook.com/profile.php?id=61583791508242" target="_blank" ><img  widht="40" height="40" src="/img/fb.png"/></a>
            </li>
            <li>
              <a href="https://x.com/CSIT58" target="_blank" ><img  widht="40" height="40" src="/img/x.png"/></a>
            </li>
            <li>
                     <a href="https://www.youtube.com/@computerscienceitconferenc7375" target="_blank" ><img  widht="40" height="40" src="/img/csitn.jpg"/></a><br><br>

              </a>
            </li>
</ul>
</div>
      </div>
    </div>

    <div class="footer-copyright grey darken-2">
      <div class="container center-align">
        <large class="white-text"> All Rights Reserved &reg;
        ACINT 2025
        </large>
      </div>
    </div>

   
  </footer>
<script type="text/javascript" src="https://code.jquery.com/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="js/materialize.min.js"></script>
<script src="js/scrolltop.js"></script>

<script src="js/main.jquery.js"></script>
</body>
<!--Import jQuery before materialize.js-->


</html>